#pragma once

#include "../core/net/tcp/tcp.h"
#include "../core/net/tcp/server.h"
#include "../core/threads/event.h"

#include "../ping-common/main.h"
#include "../ping-common/msg.h"

/* ping server class */
class ping_server : public net::tcp::server<PING_IDENT>
{
private:

	/* client class for server side connections */
	class client : public server::client
	{
	public:
		// register message types on ctor
		client(ping_server& parent, SOCKET socket) : server::client(parent, socket), m_parent(parent)
		{
			REGISTER_MESSAGE_OBJECT(client, msg_ping_request);
		}

	private:
		// ping request received
		HANDLE_MESSAGE(msg_ping_request, msg)
		{
			// send ping reply
			send(msg_ping_reply());

			// notify server
			this->m_parent.notify_request(this->get_addr());
		}

	private:
		ping_server& m_parent;
	};

public:
	ping_server(const char* address) : server<PING_IDENT>(address, 27015) {}

private:
	virtual void on_error(std::shared_ptr<client> p, const std::string& msg)
	{
		server::on_error(p, msg);

		// kick client
		if (p != nullptr)
			p->close();
	}

	virtual std::shared_ptr<server::client> create(SOCKET socket) override
	{
		return std::make_shared<client>(*this, socket);
	}

	void notify_request(const std::string& address) const
	{
		printf("ping request received from %s\r\n", address.c_str());
	}
};