#pragma once

#include "../core/net/tcp/tcp.h"
#include "../core/net/tcp/client.h"
#include "../core/threads/event.h"

#include "../ping-common/main.h"
#include "../ping-common/msg.h"

/* ping client class */
class ping_client : public net::tcp::client<PING_IDENT>
{
public:

	// add message types on ctor
	ping_client(const char* address) : client<PING_IDENT>(address, 27015)
	{
		REGISTER_MESSAGE_OBJECT(ping_client, msg_ping_reply);
	}

	// reset event
	void reset(void)
	{
		this->m_event.reset();
	}

	// wait for event
	bool wait(const double timeout)
	{
		return this->m_event.wait(timeout);
	}

private:
	HANDLE_MESSAGE(msg_ping_reply, msg)
	{
		this->m_event.trigger();
	}

private:
	thread::event m_event;
};