#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"
#include "../debug/exception.h"
#include "../utils/singleton.h"

#include "exception.h"

#include <stdio.h>
#include <string.h>

#include <string>
#include <unordered_map>

namespace types
{
	/* types manager singleton class */
	class manager : public singleton<manager>
	{
		friend class singleton<manager>;

	public:

		// register C to translated type conversion
		void register_type(const std::string& ctype, const std::string& ttype)
		{
			_debug("registering type \"%s\" as \"%s\"", ctype.c_str(), ttype.c_str());

			if(this->m_forward.find(ctype) == this->m_forward.end())
				this->m_forward.emplace(std::make_pair(ctype, ttype));

			if(this->m_inverse.find(ttype) == this->m_inverse.end())
				this->m_inverse.emplace(std::make_pair(ttype, ctype));
		}

		// translate ctype
		std::string get_name_from_type(const std::string& ctype) const
		{
			auto it = this->m_forward.find(ctype);

			if (it == this->m_forward.end())
				throw_exception(cannot_resolve_typename_exception, ctype);

			return it->second;
		}

		// inverse translate
		std::string get_type_from_name(const std::string& ttype) const
		{
			auto it = this->m_inverse.find(ttype);

			if (it == this->m_inverse.end())
				throw_exception(cannot_resolve_typename_exception, ttype);

			return it->second;
		}

	private:

		// ctor
		manager(void) {}

		// lists for conversion
		std::unordered_map<std::string, std::string> m_forward, m_inverse;
	};

	/* type_auto_register class */
	class auto_register
	{
	public:
		auto_register(const std::string& ctype, const std::string& ttype)
		{
			get_instance<types::manager>()->register_type(ctype, ttype);
		}
	};
};

// translate type to name
template<typename type> std::string get_name_from_type(void)
{
	return get_instance<types::manager>()->get_name_from_type(typeid(type).name());
}

template<typename type> std::string get_name_from_type(const type* p)
{
	return get_name_from_type<type>();
}

// return true if types matches
static bool is_type_name(const std::string& type1, const std::string& type2)
{
	return _strcmpi(type1.c_str(), type2.c_str()) == 0;
}

template<typename type> bool is_type_name(const std::string& name)
{
	return is_type_name(get_name_from_type<type>(), name);
}

// translate name to type
static std::string get_type_from_name(const std::string& name)
{
	return get_instance<types::manager>()->get_type_from_name(name);
}

// register typename
#define REGISTER_TYPENAME_EX(class, string, var)	types::auto_register register_type_##var(typeid(class).name(), string);

#define REGISTER_TYPENAME(type)						REGISTER_TYPENAME_EX(type, #type, type);