#include "type.h"
#include "endian.h"

#define REGISTER_CTYPE(type)						REGISTER_TYPENAME(type); REGISTER_ENDIANTYPE(type);
#define REGISTER_CTYPE_EX(class, string, var)		REGISTER_TYPENAME_EX(class, string, var); REGISTER_ENDIANTYPE_EX(class, string, var);

// initialize singleton
INITIALIZE_SINGLETON_EX(types::manager, types_manager);
INITIALIZE_SINGLETON_EX(endian::manager, endian_manager);

// register common types
REGISTER_CTYPE(bool);
REGISTER_CTYPE(size_t);

REGISTER_CTYPE(float);
REGISTER_CTYPE(double);
REGISTER_CTYPE_EX(long double, "long double", long_double);

REGISTER_CTYPE(char);
REGISTER_CTYPE(short);
REGISTER_CTYPE(int);
REGISTER_CTYPE(long);
REGISTER_CTYPE_EX(long long, "long long", long_long);

REGISTER_CTYPE_EX(signed char, "signed char", signed_char);
REGISTER_CTYPE_EX(signed short, "signed short", signed_short);
REGISTER_CTYPE_EX(signed int, "signed int", signed_int);
REGISTER_CTYPE_EX(signed long, "signed long", signed_long);
REGISTER_CTYPE_EX(signed long long, "signed long long", signed_long_long);

REGISTER_CTYPE_EX(unsigned char, "unsigned char", unsigned_char);
REGISTER_CTYPE_EX(unsigned short, "unsigned short", unsigned_short);
REGISTER_CTYPE_EX(unsigned int, "unsigned int", unsigned_int);
REGISTER_CTYPE_EX(unsigned long, "unsigned long", unsigned_long);
REGISTER_CTYPE_EX(unsigned long long, "unsigned long long", unsigned_long_long);