#pragma once

#include "../utils/utils.h"
#include "../debug/safe.h"

#include <string>
#include <vector>

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <cstring>

// format to std::string
static std::string format(const char* p, ...)
{
	std::string ret = "";

	char* msg = nullptr;

	va_list args;

	va_start(args, p);

	do
	{
		size_t len = 0;

		// compute length of string
		{
			va_list args_copy;

			va_copy(args_copy, args);

			len = MAKE_ADD((size_t)vsnprintf(nullptr, 0, p, args_copy), (size_t)1);

			va_end(args_copy);
		}

		if (len <= 0)
			break;

		// allocate memory
		msg = new char[len];
		memset(msg, 0, len);

		// read data
		if(vsnprintf(msg, len, p, args) < 0)
			break;

		ret = std::string(msg);

	} while (false);

	va_end(args);

	// delete memory
	delete[] msg;
	msg = nullptr;

	return ret;
}

// tokenize string
std::vector<std::string> tokenize(std::string s, char token, bool treat_consecutive_as_sinle=true);

// return true if string ends with
static bool str_ends_with(const char* string, const char* substring)
{
	if (string == nullptr || substring == nullptr)
		return false;

	size_t n1 = strlen(string);
	size_t n2 = strlen(substring);

	if (n1 < n2)
		return false;

	return _strnicmp(string + n1 - n2, substring, n2) == 0;
}

// std::string version
static bool str_ends_with(const std::string& string, const std::string& substring)
{
	return str_ends_with(string.c_str(), substring.c_str());
}

// return true if string starts with
static bool str_begins_with(const char* string, const char* substring)
{
	if (string == nullptr || substring == nullptr)
		return false;

	size_t len1 = strlen(string);
	size_t len2 = strlen(substring);

	if (len1 < len2)
		return false;

	return strncmp(string, substring, len2) == 0;
}

// std::string version
static bool str_begins_with(const std::string& string, const std::string& substring)
{
	return str_begins_with(string.c_str(), substring.c_str());
}
