#pragma once

#include <string>
#include <vector>

#include "../utils/utils.h"

// split path into directory + file
static auto split_file_path(std::string filename)
{
	// return struct
	struct
	{
		std::string directory, file;
	} ret_s;

	// find last backslash
	auto pos = filename.find_last_of("/\\");

	// divide string
	if (pos == std::string::npos)
		ret_s.file = filename;
	else
	{
		ret_s.directory = filename.substr(0, pos);
		ret_s.file = filename.substr(pos + 1);
	}

	// return
	return ret_s;
}

// split path into file + ext
static auto split_file_ext(std::string filename)
{
	// return struct
	struct
	{
		std::string file, ext;
	} ret_s;

	// find last backslash
	auto pos = filename.find_last_of(".");

	// divide string
	if (pos == std::string::npos)
		ret_s.file = filename;
	else
	{
		ret_s.file = filename.substr(0, pos);
		ret_s.ext = filename.substr(pos + 1);
	}

	// return
	return ret_s;
}

// split path into directory + file + ext
static auto split_file_parts(std::string filename)
{
	// return struct
	struct
	{
		std::string directory, file, ext;
	} ret_s;

	// first split filename into directory and filename
	auto tmp1 = split_file_path(filename);

	ret_s.directory = std::move(tmp1.directory);

	// then split filename itself into file and extension
	auto tmp2 = split_file_ext(tmp1.file);

	ret_s.file = std::move(tmp2.file);
	ret_s.ext = std::move(tmp2.ext);

	// return result
	return ret_s;
}
