#include "../types/type.h"
#include "../instancers/instancer.h"

#include "exception.h"
#include "base.h"
#include "file.h"

#include "fs/object.h"

#include <string>

/*
DECLARE_TYPENAME(storage_buffer);
DECLARE_TYPENAME(storage_string);
*/

using storage_base_t = storage::base;

DECLARE_INSTANCER(storage_base_t);

// unpack from storage buffer
void storage::container::unpack(const storage::buffer& buffer, std::function<std::shared_ptr<storage::base>(const std::string&)> _create)
{
	// create storage file system first
	auto fs = unpack_ex(buffer);

	if (fs == nullptr)
		throw_exception(invalid_filesystem_exception);

#if 0
	// check if file is protected by a password
	if (fs->is_encrypted())
	{
		// create crypto factory
		auto pCryptoFactory = create_instance<crypto_factory_base>(pStorageFileSystem->get_crypto_factory_name());

		// create decoder
		pStorageFileSystem->set_decoder(pCryptoFactory->create_decoder());
	}
#endif

	// retrieve list
	load_objects(fs, _create);
}

// generic push method
void storage::base::generic_push(storage::fs::object_base& obj, const void* base_address, struct storage::list_s* storage_list, size_t num_elems) const
{
	if (storage_list == nullptr && num_elems > 0)
		return;

	obj.set_type_name(get_typename());

	for (size_t i = 0; i < num_elems; i++)
	{
		if (storage_list[i].bytes_size == 0)
			continue;

		auto name = std::string(storage_list[i].name);
		auto owner = std::string(storage_list[i].owner);
		auto type = get_instance<types::manager>()->get_name_from_type(storage_list[i].type);

		if (storage_list[i].is_object)
		{
			storage::base* sub_base = ((storage::base*)(MAKE_ADDRESS((unsigned char*)base_address, MAKE_ADD(storage_list[i].bytes_offset, storage_list[i].object_base_offset))));

			auto sub_object = obj.create_sub_object(owner, name);

			if (sub_object != nullptr)
				sub_base->push(*sub_object);
		}
		else
			obj.push_var(owner, name, type, storage_list[i].bytes_size, (void*)MAKE_ADDRESS((unsigned char*)base_address, storage_list[i].bytes_offset));
	}

	custom_push(obj);
}

// generic pop method
void storage::base::generic_pop(const storage::fs::object_base& obj, const void* base_address, struct storage::list_s* storage_list, size_t num_elems)
{
	if (storage_list == nullptr && num_elems > 0)
		return;

	if (obj.get_type_name() != get_typename())
		throw_exception(wrong_type_exception);

	for (size_t i = 0; i < num_elems; i++)
	{
		if (storage_list[i].bytes_size == 0)
			continue;

		auto name = std::string(storage_list[i].name);
		auto owner = std::string(storage_list[i].owner);
		auto type = get_instance<types::manager>()->get_name_from_type(storage_list[i].type);

		if (!storage_list[i].is_object)
		{
			if (!obj.pop_var(owner, name, type, storage_list[i].bytes_size, (void*)MAKE_ADDRESS((unsigned char*)base_address, storage_list[i].bytes_offset)))
				throw_exception(unknown_var_exception);
		}
		else
		{
			auto sub_object = obj.get_sub_object(owner, name);

			if (sub_object == nullptr)
				throw_exception(unknown_var_exception);

			storage::base* sub_base = ((storage::base*)MAKE_ADDRESS((unsigned char*)base_address, MAKE_ADD(storage_list[i].bytes_offset, storage_list[i].object_base_offset)));

			sub_base->pop(*sub_object);
		}
	}

	custom_pop(obj);
}

/*
// push storage buffer
void storage_buffer::push(storage::object& obj) const
{
	// write size
	obj.add_variable(get_type_name(), "size", "size_t", sizeof(this->m_nSize), (void*)&this->m_nSize);

	// write data
	obj.add_variable(get_type_name(), "data", "unsigned char", MAKE_MULT(this->m_nSize, sizeof(unsigned char)), (void*)this->m_pData);

	// set typename
	obj.set_type_name(get_type_name());
}

// pop storage buffer
void storage_buffer::pop(const storage::object& obj)
{
	// check typename
	if (obj.get_type_name() != get_type_name())
		throwException(WrongTypeException);

	// free existing data
	if (this->m_pData != nullptr)
		free(this->m_pData);

	this->m_pData = nullptr;
	this->m_nSize = 0;

	try
	{
		// read size
		obj.read_variable(get_type_name(), "size", "size_t", sizeof(this->m_nSize), (void*)&this->m_nSize);
	}
	catch (...)
	{
		throwException(UnknownVarException);
	}
	
	// allocate space and read data
	this->m_pData = (unsigned char*)malloc(this->m_nSize);

	if (this->m_pData == nullptr)
		throwException(MemoryAllocationException, this->m_nSize);

	try
	{
		obj.read_variable(get_type_name(), "data", "char", MAKE_MULT(this->m_nSize, sizeof(char)), this->m_pData);
	}
	catch (...)
	{
		// free temporary string
		if (this->m_pData != nullptr)
			free(this->m_pData);

		this->m_pData = nullptr;
		this->m_nSize = 0;

		throwException(UnknownVarException);
	}
}
*/