#pragma once

#include "../../debug/exception.h"
#include "../../types/endian.h"
#include "../../hash/checksum32.h"

#include "../buffer.h"

#include "encode.h"
#include "base.h"

#include <string>
#include <list>

namespace storage::fs
{
	/* file system writer class */
	class writer_base : public base
	{
	public:

		// constructor
		writer_base(uint32_t file_type, uint32_t encryption_key, size_t encryption_block_size, unsigned long encoding_flags) : base(file_type, encryption_key, encryption_block_size)
		{
			this->m_encoding_flags = encoding_flags;
		}

#if 0
		// system to encode file
		virtual void set_encoder(std::shared_ptr<const encoder_base>) = 0;

		// add signature
		virtual void add_signature(std::shared_ptr<const signature_base> pSignature) = 0;
#endif

		// create from storage buffer list
		virtual void create(const std::list<storage::buffer>& list) = 0;

		// export into storage buffer
		storage::buffer pack(void) const
		{
			// copy internal buffer
			storage::buffer ret = this->m_buffer;

			// finalize buffer
			finalize(ret);

			// eventually padd with zeros for encryption
			size_t padding = MAKE_SUB(ret.size(), sizeof(struct header_s)) % sizeof(uint32_t);

			if (padding > 0)
				ret.allocate(MAKE_SUB(sizeof(uint32_t), padding));

			// fill in headers
			auto hdr = ret.ptr<struct header_s>(0, sizeof(struct header_s));

			hdr->ident = htof(this->m_file_type);
			hdr->checksum = 0;

			auto seed = MAKE_UINT32(rand() % 0xFFFF) | (MAKE_UINT32(rand() % 0xFFFF) << 16);

			hdr->seed = htof(seed);

			// checksum
			hdr->checksum = checksum32(ret.data(), ret.size());

			// encrypt
			encrypt((uint32_t*)(MAKE_ADDRESS(ret.data(), sizeof(struct header_s))), MAKE_SUB(ret.size(), sizeof(struct header_s)) / sizeof(uint32_t), this->m_encryption_key ^ seed, true);

			return ret;
		}

		// set encoding flags
		void set_encoding_flags(unsigned long encoding_flags)
		{
			this->m_encoding_flags = encoding_flags;
		}

		// get encoding flags
		unsigned long get_encoding_flags(void) const
		{
			return this->m_encoding_flags;
		}

	protected:
		virtual void finalize(storage::buffer&) const {}

	private:
		unsigned long m_encoding_flags;
	};

	std::shared_ptr<writer_base> create_writer(uint32_t ident, uint32_t encryption_key, size_t encryption_block_size, unsigned long encoding_flags);
};
