#pragma once

#include "../../../debug/exception.h"

#include "../../buffer.h"

#include "../base.h"
#include "../writer.h"
#include "../encode.h"

#include "header.h"
#include "object.h"

#include <list>

namespace storage::fs::spc0
{
	/* write class */
	class writer : public storage::fs::writer_base
	{
	public:
		// import constructor
		using storage::fs::writer_base::writer_base;

		virtual std::shared_ptr<object_base> create_object(void) const override
		{
			return std::make_shared<storage::fs::spc0::object>();
		}

#if 0
		// add signature to file
		virtual void add_signature(std::shared_ptr<const signature_base> pSignature) override
		{
			if (pSignature != nullptr)
				throwException(UnableToAddSignatureException);
		}

		// encoder are not supported in SPC0
		virtual void set_encoder(std::shared_ptr<const encoder_base>) override
		{
			throwException(UnableToSetKeyException);
		}
#endif

		// create from storage buffer list
		virtual void create(const std::list<storage::buffer>& list) override
		{
			// storage buffer
			storage::buffer ret, ofs_table, all_buffers;

			// fill-in header file
			ret.allocate<struct header_s>();

			ret.ptr<struct header_s>(0)->num_buffers = htof(MAKE_UINT64(list.size()));

			// add all buffers to "all_buffers" buffer and save offsets
			for (auto& v : list)
			{
				struct buffer_s s;

				// encode buffer
				auto encoded = encode(v, get_encoding_flags());

				s.encoding = htof(MAKE_UCHAR(encoded.encoding));
				s.offset = htof(MAKE_UINT64(all_buffers.append(encoded.buffer, false)));
				s.size = htof(MAKE_UINT64(encoded.buffer.size()));

				ofs_table.append(s, false);
			}

			// write offset table
			ret.ptr<struct header_s>(0)->buffers_table_offset = htof(MAKE_UINT64(ret.append(ofs_table, false)));
			ret.ptr<struct header_s>(0)->buffers_data_offset = htof(MAKE_UINT64(ret.append(all_buffers, false)));

			// set current buffer
			set(ret);
		}
	};
};