#pragma once

#include "../../../debug/exception.h"

#include "../../buffer.h"

#include "../base.h"
#include "../encode.h"

namespace storage::fs::spc0
{
	// version
	static constexpr uint32_t IDENT_VERSION = 'SPC0';

	// header structure
#pragma pack(push, 8)
	struct header_s
	{
		uint32_t ident;
		uint32_t checksum;

		uint64_t num_buffers;
		uint64_t buffers_table_offset;

		uint32_t seed;

		uint64_t buffers_data_offset;

		uint32_t _reserved[10];
	};

	struct buffer_s
	{
		unsigned char encoding;
		uint64_t offset;
		uint64_t size;
	};
#pragma pack(pop)			
};
