#pragma once

#include "../../debug/exception.h"
#include "../../types/endian.h"
#include "../../hash/checksum32.h"

#include "../buffer.h"

#include "encode.h"
#include "base.h"

#include <string>
#include <list>

namespace storage::fs
{
	/* file system reader class */
	class reader_base : public base
	{
	public:
		// import constructor
		using base::base;

#if 0
		// system to decode file
		virtual void set_decoder(std::shared_ptr<decoder_base>) = 0;
#endif

		// get list of storage buffer
		virtual std::list<storage::buffer> get_list(void) = 0;

#if 0
		// get list of signatures
		virtual std::list<std::shared_ptr<const signature_base>> get_signatures(void) = 0;

		// return true if requires a key to unlock
		virtual bool is_encrypted(void) const = 0;

		// return encoder type
		virtual std::string get_crypto_factory_name(void) const = 0;

		// return true if file has embed signatures
		virtual bool hasSignatures(void) const = 0;
#endif

		// return true if file has data
		virtual bool has_data(void) const = 0;

		// import from storage buffer
		void unpack(const storage::buffer& buf)
		{
			// local copy buffer for checksum manipulation
			this->m_buffer = buf;

			// read header
			auto hdr = this->m_buffer.ptr<struct header_s>(0, sizeof(struct header_s));

			// check ident
			if (ftoh(hdr->ident) != this->m_file_type)
			{
				this->m_buffer.clear();

				throw_exception(wrong_file_type_exception);
			}

			// unencrypt data
			encrypt((uint32_t*)MAKE_ADDRESS(this->m_buffer.data(), sizeof(struct header_s)), MAKE_SUB(this->m_buffer.size(), sizeof(struct header_s)) / sizeof(uint32_t), this->m_encryption_key ^ ftoh(hdr->seed), false);

			// restore original header
			auto old_checksum = ftoh(hdr->checksum);
			hdr->checksum = 0;

			// verify checksum
			auto new_checksum = checksum32(this->m_buffer.data(), this->m_buffer.size());

			if (new_checksum != old_checksum)
			{
				this->m_buffer.clear();

				throw_exception(wrong_checksum_exception);
			}
		}

	protected:
		virtual void initialize(storage::buffer&) {}
	};

	std::shared_ptr<reader_base> create_reader(uint32_t ident, uint32_t encryption_key, size_t encryption_block_size);
};
