#include "base.h"
#include "reader.h"
#include "writer.h"
#include "object.h"

#include "spc0/header.h"
#include "spc0/reader.h"
#include "spc0/writer.h"
#include "spc0/object.h"

#include <memory>

 // create file system writer
std::shared_ptr<storage::fs::writer_base> storage::fs::create_writer(uint32_t type_ident, uint32_t encryption_key, size_t encryption_block_size, unsigned long ulEncodingFlags)
{
	// check ident
	switch (type_ident)
	{
		case storage::fs::spc0::IDENT_VERSION:
			return std::make_shared<storage::fs::spc0::writer>(type_ident, encryption_key, encryption_block_size, ulEncodingFlags);
			break;

		default:
			throw_exception(wrong_file_type_exception);
	}
}

// create file system reader
std::shared_ptr<storage::fs::reader_base> storage::fs::create_reader(uint32_t type_ident, uint32_t encryption_key, size_t encryption_block_size)
{
	// check ident
	switch (type_ident)
	{
		case storage::fs::spc0::IDENT_VERSION:
			return std::make_shared<storage::fs::spc0::reader>(type_ident, encryption_key, encryption_block_size);
			break;

		default:
			throw_exception(wrong_file_type_exception);
	}
}
