#pragma once

#include "../../debug/exception.h"

// multiple_container_exception exception class
class multiple_container_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Container has multiple items!";
	}
};

// invalid_filesystem_exception exception class
class invalid_filesystem_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid file system!";
	}
};

// wrong_file_type_exception exception class
class wrong_file_type_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid File type!";
	}
};

// wrong_checksum_exception exception class
class wrong_checksum_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Data may have been corrupted. Aborting!";
	}
};

// invalid_buffer_exception exception class
class invalid_buffer_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Buffer is invalid. Aborting!";
	}
};