#pragma once

#include "../../debug/exception.h"
#include "../../encode/rle0.h"
#include "../../encode/rle8.h"

#include "../buffer.h"

#include "exception.h"

#define FLAG_ENABLE_RLE8			(1 << 0)
#define FLAG_ENABLE_RLE0			(1 << 1)

namespace storage::fs
{
	// type of encoding
	enum
	{
		ENCODING_NONE = 0,
		ENCODING_RLE8 = 1,
		ENCODING_RLE0 = 2,
	};

	// encode storage buffer
	static auto encode(const storage::buffer& buf, unsigned long flags)
	{
		struct
		{
			int encoding;
			storage::buffer buffer;
		} ret;

		// try all methods
		const size_t num_buffers = 3;

		storage::buffer buffers[num_buffers];

		buffers[ENCODING_NONE] = buf;

		for (size_t i = 1; i < num_buffers; i++)
			buffers[i] = buffers[0];

		if ((flags & FLAG_ENABLE_RLE8) != 0)
			buffers[ENCODING_RLE8] = encoder::rle8::encode(buf);

		if ((flags & FLAG_ENABLE_RLE0) != 0)
			buffers[ENCODING_RLE0] = encoder::rle0::encode(buf);

		// find best
		size_t min_size = buffers[0].size();
		ret.encoding = 0;

		for (size_t i = 1; i < num_buffers; i++)
		{
			if (buffers[i].size() < min_size)
			{
				min_size = buffers[i].size();
				ret.encoding = (int)i;
			}
		}

		// return
		ret.buffer = buffers[ret.encoding];

		return ret;
	}

	// decode storage buffer
	static storage::buffer decode(const storage::buffer& buf, int encoding)
	{
		switch (encoding)
		{
			case ENCODING_NONE:
				return buf;

			case ENCODING_RLE8:
				return encoder::rle8::decode(buf);

			case ENCODING_RLE0:
				return encoder::rle0::decode(buf);

			default:
				throw_exception(unknown_encoding_exception, encoding);
		}
	}
};