#pragma once

#include "../debug/exception.h"

#include <string>

// register_access_exception exception class
class register_access_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot access registry data!";
	}
};

// invalid_offset_exception exception class
class invalid_offset_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid offset!";
	}
};

// type_fit_exception exception class
class type_fit_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "type does not fit in available buffer space!";
	}
};

// unknown_resource_exception exception class
class unknown_resource_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Unknown resource!";
	}
};

// buffer_read_exception exception class
class buffer_read_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Erroneous buffer read exception!";
	}
};

// not_storage_base_object_exception exception class
class not_storage_base_object_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Object is not an storeable object!";
	}
};

// wrong_type_exception exception class
class wrong_type_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Incorrect typename!";
	}
};

// unknown_var_exception exception class
class unknown_var_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Unknown variable";
	}
};

// unknown_encoding_exception exception class
class unknown_encoding_exception : public exception::base
{
public:
	unknown_encoding_exception(int encoding)
	{
		this->m_encoding = encoding;
	}

	virtual std::string to_string(void) const override
	{
		char szTmp[64];
		snprintf(szTmp, sizeof(szTmp), "%d", this->m_encoding);

		return std::string("Unknown encoding method #") + std::string(szTmp) + std::string("!");
	}

private:
	int m_encoding;
};

/* bytesize_not_matching_exception exception class */
class bytesize_not_matching_exception : public exception::base
{
public:
	bytesize_not_matching_exception(const std::string& name, const std::string& type)
	{
		this->m_name = name;
		this->m_type = type;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("Wrong byte size for type \"") + this->m_type + ("\" in variable \"") + this->m_name + ("\" !");
	}

private:
	std::string m_name, m_type;
};

/* bigendian_exception exception class */
class bigendian_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot read/write files on a big endian machine!";
	}
};
