#pragma once

#include "../utils/utils.h"
#include "../exception.h"

#include "exception.h"

#include <string>
#include <cstdlib>
#include <cstdio>

namespace resources
{
	// load file
	static unsigned char* load_from_file(const std::string& filename, size_t& bytes_size)
	{
		FILE* p = nullptr;

		// open file
		fopen_s(&p, filename.c_str(), "rb");

		if (p == nullptr)
			throw_exception(cannot_open_file_exception, filename);

		// computes file size
		fseek(p, 0, SEEK_END);
		bytes_size = ftell(p);
		fseek(p, 0, SEEK_SET);

		// allocate memory
		unsigned char* data = (unsigned char*)malloc(bytes_size);

		if (data == nullptr)
		{
			fclose(p);

			throw_exception(memory_allocation_exception, bytes_size);
		}

		// read memory
		if (fread(data, sizeof(unsigned char), bytes_size, p) != bytes_size)
		{
			free(data);
			fclose(p);

			throw_exception(cannot_read_data_exception, filename);
		}

		// close file
		fclose(p);

		// return pointer
		return data;
	}

	// save file
	static void save_to_file(const std::string& filename, const unsigned char* data, const size_t bytes_size)
	{
		FILE* p = nullptr;

		// open file
		fopen_s(&p, filename.c_str(), "wb+");

		if (p == nullptr)
			throw_exception(cannot_open_file_exception, filename);

		// write data
		if (bytes_size != 0)
		{
			if (__ISNULLPTR(data))
				throw_exception(null_pointer_exception);

			if (fwrite(data, sizeof(unsigned char), bytes_size, p) != bytes_size)
			{
				fclose(p);

				throw_exception(cannot_write_data_exception, filename);
			}
		}

		// close file
		fclose(p);
	}
};
