#pragma once

#include "../debug/exception.h"

/* name_already_exists_exception exception class */
class name_already_exists_exception : public exception::base
{
public:
	name_already_exists_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Entity \"" + this->m_name + "\" already exists!";
	}

private:
	std::string m_name;
};

/* no_mnemonic_exception exception class */
class no_mnemonic_exception : public exception::base
{
public:
	no_mnemonic_exception(const std::string& uid)
	{
		this->m_uid = uid;
	}

	virtual std::string to_string(void) const override
	{
		return "Entity \"" + this->m_uid + "\" has no mnemonic or was not found!";
	}

private:
	std::string m_uid;
};

/* mnemonic_not_found_exception exception class */
class mnemonic_not_found_exception : public exception::base
{
public:
	mnemonic_not_found_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Mnemonic \"" + this->m_name + "\" was not found!";
	}

private:
	std::string m_name;
};

/* invalid_uid_exception exception class */
class invalid_uid_exception : public exception::base
{
public:
	invalid_uid_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Invalid UID \"" + this->m_name + "\" !";
	}

private:
	std::string m_name;
};

/* cannot_identify_self_exception exception class */
class cannot_identify_self_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Cannot identify self !";
	}
};