#pragma once

#include "../utils/utils.h"
#include "../resources/uid.h"
#include "../types/type.h"

#include <string>

namespace message
{
	/* message base class */
	class base
	{
	public:

		// assign uid on creation
		base(void)
		{
			this->m_id = resources::uid::create();
		}

		virtual ~base(void) {}

		// get message id
		const std::string& id(void) const
		{
			return this->m_id;
		}

		// get specialized class type
		virtual std::string get_type_name(void) const
		{
			return get_instance<types::manager>()->get_name_from_type(typeid(*this).name());
		}

	private:
		std::string m_id;
	};
};
