#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"

#include <string>

/* array_out_of_bounds_exception exception class */
class array_out_of_bounds_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Array out of bounds!";
	}
};

/* map_size_exception exception class */
class map_size_exception : public exception::base
{
public:
	map_size_exception(size_t width1, size_t height1, size_t width2, size_t height2)
	{
		this->m_width1 = width1;
		this->m_height1 = height1;

		this->m_width2 = width2;
		this->m_height2 = height2;
	}

	virtual std::string to_string(void) const override
	{
		char szTmp[512];

		snprintf(szTmp, sizeof(szTmp), "Size Mismatch! Map 1 is %zux%zu while Map 2 is %zux%zu!", this->m_width1, this->m_height1, this->m_width2, this->m_height2);

		return std::string(szTmp);
	}

private:
	size_t m_width1, m_height1, m_width2, m_height2;
};


/* map_function_exception exception class */
class map_function_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Invalid function!";
	}
};
