#pragma once

// 32 bits checksum helper function
static uint32_t checksum32(const unsigned char* p, size_t size)
{
    uint32_t sum = 0;

    // add longs as long as possible
    while (size >= sizeof(uint32_t))
    {
        sum += ~*((uint32_t*)p);
        p += sizeof(uint32_t);
        size -= sizeof(uint32_t);
    }

    // then add shorts
    while (size >= sizeof(uint16_t))
    {
        sum += ~*((uint16_t*)p);
        p += sizeof(uint16_t);
        size -= sizeof(uint16_t);
    }

    // then add chars
    while (size >= sizeof(uint8_t))
    {
        sum += ~*((uint8_t*)p);
        p += sizeof(uint8_t);
        size -= sizeof(uint8_t);
    }

    return ~sum;
}
