#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"
#include "../debug/evemon.h"
#include "../scope/ticket.h"

#include "exception.h"

#include <functional>

namespace event
{
	/* callback template class */
	template<typename type_ret, typename ... params> class callback
	{
	public:
		using function_t = std::function<type_ret(params ...)>;

		// callbacks are created for a given scope
		callback(function_t func, const scope::ticket::handle& scope_ticket_handle) : m_func(func), m_scope_ticket_handle(scope_ticket_handle) {}

		// default move and copy
		callback(const callback&) = default;
		callback(callback&&) = default;

		// check if it is valid
		bool is_valid(void)
		{
			// check if callback exists
			if (!this->m_func)
				return false;

			// check if target still exists
			auto lk = this->m_scope_ticket_handle.lock();

			return this->m_scope_ticket_handle.is_alive();
		}

		// call function
		type_ret call(params ... args)
		{
			// check if callback exists
			if (!this->m_func)
				throw_exception(invalid_callback_exception);

			// check if target still exists
			auto lk = this->m_scope_ticket_handle.lock();

			if (!this->m_scope_ticket_handle.is_alive())
				throw_exception(callback_dead_exception);

			// call function
			return this->m_func(args ...);
		}

	private:
		function_t m_func;
		scope::ticket::handle m_scope_ticket_handle;
	};
};
