#include "../core/utils/utils.h"
#include "../core/jobs/jobsman.h"
#include "../common/common.h"

#ifdef _WIN32
#include <windows.h>
#endif

#define LIBNAME	"local job manager"

/* local_job_manager_interface specialization class */
class local_job_manager_interface : public job_manager_interface
{
public:

	// queue a job to the local manager
	virtual void queue(std::shared_ptr<job_base> p) const override
	{
		get_instance<jobs_manager>()->queue(p);
	}
};

REGISTER_INTERFACE(local_job_manager_interface, job_manager_interface);

/* sample remote module */
class sample_module : public remote_module
{
public:
	IMPLEMENT_STORAGE;

	sample_module(void)
	{
		this->m_data = 0;
	}

	void set(int data)
	{
		this->m_data = data;
	}

	const int get(void) const
	{
		return this->m_data;
	}

private:
	int m_data;
};

BEGIN_STORAGE(sample_module)
{
	DECLARE_STORAGE(sample_module, m_data),
} END_STORAGE(sample_module, sample_module);

DECLARE_INSTANCEABLE_OBJECT(sample_module, remote_module);

/* external function */
extern "C" DLLEXPORT void some_work(void)
{
	// create instance
	auto p = create_instance<remote_module>("local job manager/sample_module");

	// set value
	p->set(7);

	// print value
	printf("value = %d\r\n", p->get());
}

// dll attach
void CONSTRUCTOR dll_attach(void)
{
	get_instance<library::manager>()->set_name(LIBNAME);
}

// dll detach
void DESTRUCTOR dll_detach(void)
{
}

// dll entry point
#ifdef _WIN32

BOOL APIENTRY DllMain(HMODULE hModule, DWORD  ul_reason_for_call, LPVOID lpReserved)
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
		dll_attach();
		break;

	case DLL_PROCESS_DETACH:
		dll_detach();
		break;
	}

    return TRUE;
}

#endif
