#pragma once

#include "../debug/exception.h"
#include "../debug/exdebug.h"
#include "../debug/evemon.h"

#include "singleton.h"

#include <string>
#include <unordered_map>

/* unknown_singleton_exception exception class */
class unknown_singleton_exception : public exception::base
{
public:
	unknown_singleton_exception(const std::string& type)
	{
		this->m_type = type;
	}

	virtual std::string to_string(void) const override
	{
		return "Unknown singleton \"" + this->m_type + "\" !";
	}

private:
	std::string m_type;
};

/* singleton_manager singleton class */
class singleton_manager : public singleton<singleton_manager>
{
public:

	// check if exists
	bool has(const std::string& type_name) const
	{
		return this->m_list.find(type_name) != this->m_list.end();
	}

	// add to list
	void add(const std::string& type_name, void* p)
	{
		// skip if already into list
		if (has(type_name))
			return;

		// add to list
		_debug("adding \"%s\" to singleton manager", type_name.c_str());

		this->m_list.emplace(std::make_pair(type_name, p));
	}

	// get from list
	void* get(const std::string& type_name) const
	{
		auto it = this->m_list.find(type_name);

		// throw exception not found
		if (it == this->m_list.end())
			throw_exception(unknown_singleton_exception, type_name);

		// return pointer
		return it->second;
	}

	// register object
	class auto_register
	{
	public:
		auto_register(const std::string& type_name, void* p)
		{
			::get_instance<singleton_manager>()->add(type_name, p);
		}
	};

private:
	std::unordered_map<std::string, void*> m_list;
};

#define BIND_SINGLETON_EX(type, varname)		singleton_manager::auto_register g_auto_register_##varname(typeid(type).name(), type::instance);
#define BIND_SINGLETON(type)					BIND_SINGLETON_EX(type, type)