#pragma once

#ifdef __GCC__

#include <cstring>
#include <cstdlib>
#include <cerrno>
#include <cstdio>

#define DLLEXPORT

#define CONSTRUCTOR	__attribute__((constructor))
#define DESTRUCTOR	__attribute__((destructor))

inline int _strcmpi(const char *a, const char *b)
{
	return strcasecmp(a, b);
}

inline int _strncmp(const char *a, const char *b, const size_t n)
{
	return strncmp(a, b, n);
}

inline int _strnicmp(const char *a, const char *b, const size_t n)
{
	return strncasecmp(a, b, n);
}

inline void *_aligned_malloc(const size_t size, const size_t align)
{
	return aligned_alloc(align, size);
}

inline void _aligned_free(void *mem)
{
	return free(mem);
}

inline int fopen_s(FILE **p, const char *filename, const char *mode)
{
	if(p == nullptr)
		return 121;

	*p = fopen(filename, mode);

	if(*p == nullptr)
		return errno;

	return 0;
}

#endif
