#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"

/* cannot_resolve_typename_exception exception class */
class cannot_resolve_typename_exception : public exception::base
{
public:
	cannot_resolve_typename_exception(const std::string& type_name)
	{
		this->m_type_name = type_name;
	}

	virtual std::string to_string(void) const override
	{
		return "Cannot resolve typename of \"" + this->m_type_name + "\" !";
	}

private:
	std::string m_type_name;
};

/* cannot_resolve_typename_exception exception class */
class unknown_typename_exception : public exception::base
{
public:
	unknown_typename_exception(const std::string& type_name)
	{
		this->m_type_name = type_name;
	}

	virtual std::string to_string(void) const override
	{
		return "Unknown typename \"" + this->m_type_name + "\" !";
	}

private:
	std::string m_type_name;
};

/* wrong_size_exception exception class */
class wrong_size_exception : public exception::base
{
public:
	wrong_size_exception(const size_t size1, const size_t size2)
	{
		this->m_size1 = size1;
		this->m_size2 = size2;
	}

	virtual std::string to_string(void) const override
	{
		char szTmp1[64], szTmp2[64];

		snprintf(szTmp1, sizeof(szTmp1), "%zu", this->m_size1);
		snprintf(szTmp2, sizeof(szTmp2), "%zu", this->m_size2);

		return "Wrong size " + std::string(szTmp1) + std::string(" when type size is ") + std::string(szTmp2) + std::string(" bytes!");
	}

private:
	size_t m_size1, m_size2;
};
