#include "../debug/exception.h"
#include "../debug/evemon.h"

#include <array>

// tokenize string
std::vector<std::string> tokenize(std::string s, char token, bool treat_consecutive_as_sinle)
{
	/* unexpected_termination_exception */
	class unexpected_termination_exception : public exception::base
	{
	public:
		virtual std::string to_string(void) const override
		{
			return "Unexpected string termination while inside quotes!";
		}
	};

	std::vector<std::string> ret;

	const char* str = s.c_str();
	const size_t len = strlen(str);

	// return if no string
	if (s.length() == 0)
		return ret;

	std::string curr;

	bool in_quotes = false;

	auto test = [](const char* str, int pos, int ofs, char c)
	{
		if ((pos + ofs) < 0 || (pos + ofs) >= strlen(str))
			return false;

		return str[(size_t)((int)pos + ofs)] == c;
	};

	for (size_t i = 0; i < len; i++)
	{
		// if matches token
		if (str[i] == token && !in_quotes)
		{
			// add current string
			ret.emplace_back(curr);

			// clear current string
			curr.clear();

			// skip token
			if (treat_consecutive_as_sinle)
				while ((i + 1) < len && str[i] != '\0' && str[i + 1] == token)
					i++;
		}
		// check for quotes
		else if (str[i] == '\"'/* && !test(str, (int)i, -1, '\\') && !test(str, (int)i, -2, '\\')*/)
		{
			// inverse quote status
			in_quotes = !in_quotes;
		}
		// otherelse add character
		else
		{
			/*
			if (str[i] == '\\' && str[i + 1] == '\"' && !test(str, (int)i, -1, '\\'))
			{
				curr += std::string("\"");

				i++;
			}
			else if (str[i] == '\\' && str[i + 1] == '\\')
			{
				curr += std::string("\\");

				i++;
			}
			else
			{
				char tmp[2] = { str[i], '\0' };

				curr += std::string(tmp);
			}
			*/

			char tmp[2] = { str[i], '\0' };

			curr += std::string(tmp);
		}
	}

	// throw error if in quotes
	if (in_quotes)
		throw_exception(unexpected_termination_exception);

	if (curr.length() > 0)
		ret.emplace_back(curr);

	return ret;
}