#include "../types/type.h"
#include "../instancers/instancer.h"

#include "exception.h"
#include "base.h"
#include "file.h"

#include "fs/object.h"

#include <string>

using storage_base_t = storage::base;

DECLARE_INSTANCER(storage_base_t);

// unpack from storage buffer
void storage::container::unpack(const storage::buffer& buffer, std::function<std::shared_ptr<storage::base>(const std::string&)> _create)
{
	// create storage file system first
	auto fs = unpack_ex(buffer);

	if (fs == nullptr)
		throw_exception(invalid_filesystem_exception);

#if 0
	// check if file is protected by a password
	if (fs->is_encrypted())
	{
		// create crypto factory
		auto pCryptoFactory = create_instance<crypto_factory_base>(pStorageFileSystem->get_crypto_factory_name());

		// create decoder
		pStorageFileSystem->set_decoder(pCryptoFactory->create_decoder());
	}
#endif

	// retrieve list
	load_objects(fs, _create);
}

// generic push method
void storage::base::generic_push(storage::fs::object_base& obj, const void* base_address, struct storage::list_s* storage_list, size_t num_elems, bool use_custom) const
{
	if (storage_list == nullptr && num_elems > 0)
		return;

	obj.set_type_name(get_typename());

	for (size_t i = 0; i < num_elems; i++)
	{
		if (storage_list[i].bytes_size == 0)
			continue;

		auto name = std::string(storage_list[i].name);
		auto owner = std::string(storage_list[i].owner);
		auto type = get_instance<types::manager>()->get_name_from_type(storage_list[i].type);

		if (storage_list[i].is_object)
		{
			storage::base* sub_base = ((storage::base*)(MAKE_ADDRESS((unsigned char*)base_address, MAKE_ADD(storage_list[i].bytes_offset, storage_list[i].object_base_offset))));

			auto sub_object = obj.create_sub_object(owner, name);

			if (sub_object != nullptr)
				sub_base->push(*sub_object);
		}
		else
			obj.push_var(owner, name, type, storage_list[i].bytes_size, (void*)MAKE_ADDRESS((unsigned char*)base_address, storage_list[i].bytes_offset));
	}

	if(use_custom)
		custom_push(obj);
}

// generic pop method
void storage::base::generic_pop(const storage::fs::object_base& obj, const void* base_address, struct storage::list_s* storage_list, size_t num_elems, bool use_custom)
{
	if (storage_list == nullptr && num_elems > 0)
		return;

	if (obj.get_type_name() != get_typename())
		throw_exception(wrong_type_exception);

	for (size_t i = 0; i < num_elems; i++)
	{
		if (storage_list[i].bytes_size == 0)
			continue;

		auto name = std::string(storage_list[i].name);
		auto owner = std::string(storage_list[i].owner);
		auto type = get_instance<types::manager>()->get_name_from_type(storage_list[i].type);

		if (!storage_list[i].is_object)
		{
			if (!obj.pop_var(owner, name, type, storage_list[i].bytes_size, (void*)MAKE_ADDRESS((unsigned char*)base_address, storage_list[i].bytes_offset)))
				throw_exception(unknown_var_exception);
		}
		else
		{
			auto sub_object = obj.get_sub_object(owner, name);

			if (sub_object == nullptr)
				throw_exception(unknown_var_exception);

			storage::base* sub_base = ((storage::base*)MAKE_ADDRESS((unsigned char*)base_address, MAKE_ADD(storage_list[i].bytes_offset, storage_list[i].object_base_offset)));

			sub_base->pop(*sub_object);
		}
	}

	if(use_custom)
		custom_pop(obj);
}