#pragma once

#include "../debug/exception.h"
#include "../debug/exdebug.h"
#include "../scope/exception.h"

#include "../exception.h"

#include "ticket.h"

#include <mutex>

namespace scope
{
	/* access class */
	template<class type> class access
	{
	public:
		/* access:proxy class */
		class proxy
		{
		public:

			// acquire lock on construction
			proxy(type* pointer, const scope::ticket::handle& handle) : m_lock(handle.lock())
			{
				this->m_pointer = pointer;

				if (!handle.is_alive())
					throw_exception(out_of_scope_exception);
			}

			// return pointer
			type* operator->(void)
			{
				return ptr();
			}

			// return pointer (const version)
			const type* operator->(void) const
			{
				return ptr();
			}

			// return reference
			type& operator*(void)
			{
				return *ptr();
			}

			// return reference (const version)
			const type& operator*(void) const
			{
				return *ptr();
			}

		private:

			// return pointer and trigger error if null
			type* ptr(void)
			{
				if (__ISNULLPTR(this->m_pointer))
					throw_exception(null_pointer_exception);

				return this->m_pointer;
			}

			type* m_pointer;
			std::lock_guard<std::recursive_mutex> m_lock;
		};

	public:

		// create ticket handle on construction
		access(type* parent, const scope::ticket& handle) : m_handle(handle.create_handle())
		{
			this->m_parent = parent;
		}

		// return proxy object to ensure parent is locked when it's being used
		auto get(void) const
		{
			return proxy(this->m_parent, this->m_handle);
		}

	private:
		type* m_parent;
		scope::ticket::handle m_handle;
	};
};