#pragma once

#include "../utils/singleton_manager.h"
#include "../debug/exdebug.h"

#include "manager.h"

// retrieve master library manager
static library::manager* get_base_library_manager(void)
{
	// get singleton manager of base process
	auto p = get_instance<library::manager>()->get_addr("", "get_singleton_manager");

	if (__ISNULLPTR(p))
		throw_exception(cannot_load_singleton_manager_exception);

	// resolve singleton manager
	auto manager = (*((singleton_manager * (*)(void))p))();

	if (__ISNULLPTR(manager))
		throw_exception(cannot_load_singleton_manager_exception);

	// get library manager
	return static_cast<library::manager*>(manager->get(typeid(library::manager).name()));
}

// get remote singleton
template<class type> type* get_remote_singleton(const std::string& library)
{
	// get singleton manager func addr
	auto p = get_base_library_manager()->get_addr(library, "get_singleton_manager");

	if (__ISNULLPTR(p))
		throw_exception(cannot_load_singleton_manager_exception);

	// resolve singleton manager
	auto manager = (*((singleton_manager * (*)(void))p))();

	if (__ISNULLPTR(manager))
		throw_exception(cannot_load_singleton_manager_exception);

	// get requested singleton
	return static_cast<type*>(manager->get(typeid(type).name()));
}

// check if remote singleton exists
template<class type> bool has_remote_singleton(const std::string& library)
{
	// get singleton manager func addr
	auto p = get_base_library_manager()->get_addr(library, "get_singleton_manager");

	if (__ISNULLPTR(p))
		return false;

	// resolve singleton manager
	auto manager = (*((singleton_manager * (*)(void))p))();

	if (__ISNULLPTR(manager))
		throw_exception(cannot_load_singleton_manager_exception);

	// get requested singleton
	return manager->has(typeid(type).name());
}