#include "../utils/singleton_manager.h"

#include "manager.h"

#include "interface/manager.h"

using library_manager_t = library::manager;

INITIALIZE_SINGLETON(library_manager_t);
BIND_SINGLETON(library_manager_t);

// detach all libraries
void library::manager::detach_all(void)
{
	// detach all libraries
	::get_instance<library::interface::manager>()->detach_all();

	// clear all libraries
	this->m_libraries.clear();
}

// return current library name
extern "C" DLLEXPORT const char* get_library_name(void)
{
	return ::get_instance<library::manager>()->get_name().c_str();
}