#include "tpool.h"

INITIALIZE_SINGLETON(thread_pool_manager);

// run
void thread_pool_manager::worker_thread::run(void)
{
	if (!this->m_work_pending.wait(this->m_max_inactivity_time))
	{
		this->m_stop = true;

		return;
	}

	// load job
	std::shared_ptr<job_base> p = std::atomic_load(&this->m_job);

	// skip if no job
	if (__ISNULLPTR(p))
		return;

	// run job
	p->run();

	// set slot free
	std::atomic_store(&this->m_job, std::shared_ptr<job_base>(nullptr));

	// reset event
	this->m_work_pending.reset();
}