#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"

#include <string>

/* invalid_instancer_callback_exception exception class */
class invalid_instancer_callback_exception : public exception::base
{
public:
	invalid_instancer_callback_exception(const std::string& rName)
	{
		this->m_name = rName;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("No valid instancer function for type \"") + this->m_name + std::string("\"!");
	}

private:
	std::string m_name;
};

/* unknown_instancer_exception exception class */
class unknown_instancer_exception : public exception::base
{
public:
	unknown_instancer_exception(const std::string& rName)
	{
		this->m_name = rName;
	}

	virtual std::string to_string(void) const override
	{
		return std::string("Unknown instancer \"") + this->m_name + std::string("\"!");
	}

private:
	std::string m_name;
};