#pragma once

#include "../debug/safe.h"
#include "../storage/buffer.h"

namespace encoder
{
	namespace rle8
	{
		// RLE8 encoding
		static storage::buffer encode(const storage::buffer& buf)
		{
			// create temp buffer
			storage::buffer ret;

			// browse all bytes
			for (size_t i = 0; i < buf.size(); i++)
			{
				// get current byte
				auto curr = *buf.ptr<unsigned char>(i);

				// n will hold number of repetitions
				size_t n = 1;

				// increment n as long as lower than 256 or buffer size
				while (MAKE_ADD(i, n) < buf.size() && n < 255)
				{
					// quit if bytes do no match
					if (curr != *buf.ptr<unsigned char>(MAKE_ADD(i, n)))
						break;

					// otherelse increment n
					MAKE_INC(n, (size_t)1);
				}

				// append two bytes
				ret.append<unsigned char>((unsigned char)n, false);
				ret.append<unsigned char>((unsigned char)curr, false);

				// skip N bytes
				MAKE_INC(i, n - 1);
			}

			// return new buffer
			return ret;
		}

		// RLE8 decode
		static storage::buffer decode(const storage::buffer& buf)
		{
			// create temp buffer
			storage::buffer ret;

			// loop through file
			for (size_t i = 0; i < buf.size(); MAKE_INC(i, (size_t)2))
			{
				// get current bytes
				auto occurence = *buf.ptr<unsigned char>(i);
				auto symbol = *buf.ptr<unsigned char>(MAKE_ADD(i, (size_t)1));

				// add N times
				while (occurence--)
					ret.append(symbol, false);
			}

			// return buffer
			return ret;
		}
	};
};