#pragma once

#include "evemon.h"

// assert nullptr
static bool test_nullptr(const void* p, const char* name, const char* file, unsigned int line)
{
    if (p == nullptr)
    {
        try
        {
            _event(event_type::DBG_EXDEBUG, file, line, "%s is null ptr", name);
        }
        catch (...) {}
    }

    return p == nullptr;
}

template<typename type> bool test_nullptr(const std::shared_ptr<type>& p, const char* name, const char* file, unsigned int line)
{
    return test_nullptr(p.get(), name, file, line);
}

template<typename type> bool test_nullptr(const std::unique_ptr<type>& p, const char* name, const char* file, unsigned int line)
{
    return test_nullptr(p.get(), name, file, line);
}

// assert zero
template<typename type> bool test_zero(type value, const char* name, const char* file, unsigned int line)
{
    if (value == 0)
    {
        try
        {
            _event(event_type::DBG_EXDEBUG, file, line, "%s is zero", name);
        }
        catch (...) {}
    }

    return value == 0;
}

// extended debug functions
#ifdef _EXDEBUG

#define __ISNULLPTR(ptr)	test_nullptr(ptr, #ptr, __FILE__, __LINE__)
#define __ISZERO(var)	    test_zero(var, #var, __FILE__, __LINE__)

#else

#define __ISNULLPTR(ptr)	(ptr == nullptr)
#define __ISZERO(var)	    (var == 0)

#endif