#pragma once

#include <string>
#include <functional>
#include <memory>

#include "../utils/utils.h"

 // this action will no throw exception in case of failure
#define NOTHROW(action) { try{ action; } catch(...){} }

// generic exception class
namespace exception
{
	class base
	{
	public:
		base(void) {}
		virtual ~base(void) {}

		virtual std::string to_string(void) const = 0;
	};

	// extended debug when triggering exceptions
	void ex_debug(const std::string& type, std::function<void(void)> callback);

	template<typename type> void ex_debug(std::function<void(void)> callback)
	{
		ex_debug(typeid(type).name(), callback);
	}
};

// send message to event monitor
void hook_exception(const exception::base& e, const std::string& type, const char* filename, unsigned int line);

#define throw_exception(exception_type, ...)       { exception_type e{__VA_ARGS__}; hook_exception(e, typeid(exception_type).name(), __FILE__, __LINE__); throw e; }


void breakpoint(void);

#define EX_BREAKPOINT(type)	exception::ex_debug<type>(&breakpoint);