#pragma once

#include "../core/utils/utils.h"
#include "../core/library/interface/interface.h"
#include "../core/storage/base.h"
#include "../core/storage/storage.h"
#include "../core/instancers/instancer.h"
#include "../core/jobs/jobs.h"

// sample interface
class job_manager_interface : public library::interface::base
{
public:
	virtual void queue(std::shared_ptr<job_base> p) const = 0;
};

// remote module interface
class remote_module : public storage::base, public instancer::object_base<remote_module>
{
public:
	IMPLEMENT_STORAGE;

	remote_module(void) {}

	virtual void set(int data) = 0;
	virtual const int get(void) const = 0;
};
