#include "../types/type.h"

#include "command.h"
#include "transaction.h"
#include "node.h"
#include "proxy.h"

using version_proxy_node_t = version::proxy<version::node>;
using version_proxylist_node_t = version::proxy_list<version::node>;

DECLARE_INSTANCER(version_command_t);

BEGIN_STORAGE(version_command_t)
{
	DECLARE_STORAGE(version_command_t, m_uid),
} END_STORAGE(version_command_t, version_command_t);

REGISTER_TYPENAME_EX(version_transaction_t, "version::transaction", version_transaction);

BEGIN_STORAGE_EX(version_proxy_node_t, template<>)
{
	DECLARE_STORAGE(version_proxy_node_t, m_name),
} END_STORAGE_EX(version_proxy_node_t, version_proxy_node_t, "version_proxy_node_t", template<>);

REGISTER_TYPENAME_EX(version_proxylist_node_t, "version::proxylist<node>", version_proxylist_node);

BEGIN_STORAGE(version_node_t)
{
	DECLARE_STORAGE(version_node_t, m_commands),
	DECLARE_STORAGE(version_node_t, m_parents),
	DECLARE_STORAGE(version_node_t, m_owner),
} END_STORAGE(version_node_t, version_node_t);
