#pragma once

#include "../debug/exception.h"

#include <string>

/* invalid_file_exception exception class */
class invalid_file_exception : public exception::base
{
public:
	invalid_file_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Invalid file \"" + this->m_name + "\" !";
	}

private:
	std::string m_name;
};

/* empty_transaction_exception exception class */
class empty_transaction_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Empty transaction!";
	}
};

/* corrupted_file_exception  exception class */
class corrupted_file_exception : public exception::base
{
public:
	corrupted_file_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "File \"" + this->m_name + "\" might be corrupted!";
	}

private:
	std::string m_name;
};

/* erroneous_commit_id_exception  exception class */
class erroneous_commit_id_exception : public exception::base
{
public:
	erroneous_commit_id_exception(const std::string& filename)
	{
		this->m_filename = filename;
	}

	virtual std::string to_string(void) const override
	{
		return "File \"" + this->m_filename + "\" is not a valid transaction!";
	}

private:
	std::string m_filename;
};

/* cannot_repeat_exception exception class */
class cannot_repeat_exception : public exception::base
{
public:
	cannot_repeat_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Cannot repeat transaction \"" + this->m_name + "\" ! Check that it has only 1 parent.";
	}

private:
	std::string m_name;
};

/* project_already_exists_exception exception class */
class project_already_exists_exception : public exception::base
{
public:
	virtual std::string to_string(void) const override
	{
		return "Project already exists!";
	}
};

/* unknown_commit_exception exception class */
class unknown_commit_exception : public exception::base
{
public:
	unknown_commit_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Unknown transaction \"" + this->m_name + "\" !";
	}

private:
	std::string m_name;
};

/* no_parent_exception exception class */
class no_parent_exception : public exception::base
{
public:
	no_parent_exception(const std::string& name, int id)
	{
		this->m_name = name;
		this->m_id = id;
	}

	virtual std::string to_string(void) const override
	{
		return "Transaction \"" + this->m_name + "\" does not have parent " + format("#%d", this->m_id) + " !";
	}

private:
	std::string m_name;
	int m_id;
};

/* ambiguous_name_exception exception class */
class ambiguous_name_exception : public exception::base
{
public:
	ambiguous_name_exception(const std::string& name)
	{
		this->m_name = name;
	}

	virtual std::string to_string(void) const override
	{
		return "Transaction name \"" + this->m_name + "\" is ambiguous!";
	}

private:
	std::string m_name;
};