#pragma once

#include "../storage/base.h"
#include "../storage/ext/string.h"
#include "../instancers/instancer.h"
#include "../resources/uid.h"

#include <string>

namespace version
{
	/* command class */
	class command : public storage::base, public instancer::object_base<command>
	{
	public:
		IMPLEMENT_STORAGE;

		// assign unique id on creation
		command(void)
		{
			this->m_uid = resources::uid::create();
		}

		// retrieve uid
		const std::string& uid(void)
		{
			return this->m_uid;
		}

		// get log information
		virtual std::string log(void) const = 0;

		// run command
		virtual void run(void) const = 0;

	private:
		storage::ext::string m_uid;
	};
};

using version_command_t = version::command;