#pragma once

#ifdef UNIX

#include <csignal>
#include <unistd.h>
#include <sys/socket.h>

using SOCKET = int;
using SOCKADDR = struct sockaddr;

constexpr int SOCKET_ERROR = -1;
constexpr SOCKET INVALID_SOCKET = -1;

inline void __debugbreak(void)
{
	raise(SIGTRAP);
}

inline void closesocket(SOCKET socket)
{
	shutdown(socket, SHUT_RDWR);
	close(socket);
}

#endif