#pragma once

#include "../storage/buffer.h"

#include <string>
#include <cstdlib>

namespace utils::base64
{
	static std::string encode(const storage::buffer &buffer)
	{
		std::string ret;

		const char *table = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789+/=";

		// get pointer for data
		auto data = buffer.data();

		// loop by chunks of 3 bytes
		for (size_t i = 0; i < buffer.size(); i += 3)
		{
			// get 4 words of 6 bits (= 24 bits)
			for (size_t n = 0; n < 4; n++)
			{
				unsigned char curr = 0;

				if ((8 * i + n * 6) >= (8 * buffer.size()))
				{
					switch (8 * (buffer.size() - i) / 6)
					{
						case 1:
							return ret + "==";

						case 2:
							return ret + "=";

						default:
							return ret;
					}
				}

				for (size_t k = 0; k < 6; k++)
				{
					auto ofs = 8 * i + n * 6 + k;

					if (ofs < (8 * buffer.size()))
						curr |= ((data[ofs / 8] >> (7 - (ofs % 8))) & 1) << (5 - k);
				}

				// should not happend
				if (curr >= strlen(table))
				{
					ret += "?";

					continue;
				}

				// add current word
				char szTmp[2] = { table[curr], '\0' };

				ret += szTmp;
			}
		}

		// return string
		return ret;
	}
};