#pragma once

#include "../utils/utils.h"
#include "../event/base.h"

#include <chrono>
#include <mutex>
#include <condition_variable>

namespace thread
{
	// event class
	class event : public ::event::base
	{
	public:

		// default constructor
		event(void)
		{
			this->m_flag = false;
		}

		// wait for the event, return false if timeout
		virtual bool wait(double timeout = 0) const override
		{
			std::unique_lock<std::mutex> lk(this->m_lock);

			if (timeout > 0)
			{
				return this->m_cv.wait_until(lk, std::chrono::system_clock::now() + std::chrono::duration<double, std::ratio<1>>(timeout), [&](void)
					{
						return this->m_flag;
					});
			}

			this->m_cv.wait(lk, [&](void)
				{
					return this->m_flag;
				});

			return true;
		}

		// trigger the event
		virtual void trigger(void) override
		{
			std::lock_guard<std::mutex> lk(this->m_lock);

			this->m_flag = true;

			this->m_cv.notify_all();
		}

		// reset the event
		virtual void reset(void) override
		{
			std::lock_guard<std::mutex> lk(this->m_lock);

			this->m_flag = false;

			this->m_cv.notify_all();
		}

		// return true if the event is pending
		virtual bool is_pending(void) const override
		{
			std::lock_guard<std::mutex> lk(this->m_lock);

			return !this->m_flag;
		}

	private:
		mutable std::mutex m_lock;
		mutable std::condition_variable m_cv;

		bool m_flag;
	};
};