#pragma once

#include "../strings/format.h"
#include "../instancers/instancer.h"

#include "exception.h"

#include <string>
#include <cstdio>

namespace test
{
	class base : public instancer::object_base<test::base>
	{
	public:
		virtual void run(void) const = 0;
	};

	static void print_success(const std::string& message)
	{
		fprintf(stdout, "\033[1;32m");
		fprintf(stdout, "[ SUCCESS ]\t%s", message.c_str());
		fprintf(stdout, "\033[0m");

#ifdef _WIN32
		fprintf(stdout, "\r\n");
#else
		fprintf(stdout, "\n");
#endif

	}

	static void print_failure(const std::string& message)
	{
		fprintf(stdout, "\033[1;31m");
		fprintf(stdout, "[ FAILURE ]\t%s", message.c_str());
		fprintf(stdout, "\033[0m");
		
#ifdef _WIN32
		fprintf(stdout, "\r\n");
#else
		fprintf(stdout, "\n");
#endif
	}

	static void print_comment(const std::string& message)
	{
		fprintf(stdout, "\033[1;33m");
		fprintf(stdout, "[ ------- ]\t%s", message.c_str());
		fprintf(stdout, "\033[0m");

#ifdef _WIN32
		fprintf(stdout, "\r\n");
#else
		fprintf(stdout, "\n");
#endif

	}
};

using test_base_t = test::base;

#ifdef _MSC_VER

#define _success(szfmt, ...)		                test::print_success(format(szfmt, __VA_ARGS__));
#define _failure(szfmt, ...)						test::print_failure(format(szfmt, __VA_ARGS__));
#define _comment(szfmt, ...)						test::print_comment(format(szfmt, __VA_ARGS__));

#else

#define _success(szfmt, ...)		                test::print_success(format(szfmt __VA_OPT__(,) __VA_ARGS__));
#define _failure(szfmt, ...)						test::print_failure(format(szfmt __VA_OPT__(,) __VA_ARGS__));
#define _comment(szfmt, ...)						test::print_comment(format(szfmt __VA_OPT__(,) __VA_ARGS__));

#endif

#define REGISTER_TEST(class)						DECLARE_INSTANCEABLE_OBJECT(class, test_base_t);

#include "expect_data.h"
#include "expect_string.h"
#include "expect_bool.h"
#include "expect_exception.h"
#include "expect_int.h"
#include "expect_ptr.h"