#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>

namespace test
{
	// expect a string
	static void expect_string(const std::string& label, const std::string& string1, const std::string& string2, bool ignore_case)
	{
		// check for success
		bool success = false;

		if (ignore_case)
			success = _strcmpi(string1.c_str(), string2.c_str()) == 0;
		else
			success = strcmp(string1.c_str(), string2.c_str()) == 0;

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		_failure("%s\t\"%s\" is NOT \"%s\"", label.c_str(), string1.c_str(), string2.c_str());

		// throw exception
		throw_exception(test_failed_exception);
	}
};

#define EXPECT_STR(label, string1, string2)		test::expect_string(label, string1, string2, false);
#define EXPECT_ISTR(label, string1, string2)	test::expect_string(label, string1, string2, true);