#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>
#include <memory>

namespace test
{
	// expect null value
	static void expect_null(const std::string& label, void *p)
	{
		// check for success
		bool success = (p == nullptr);

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		_failure("%s\t%p is NOT nullptr", label.c_str(), p);

		// throw exception
		throw_exception(test_failed_exception);
	}

	// expect null value (shared_ptr version)
	template<typename type> void expect_null(const std::string& label, std::shared_ptr<type> p)
	{
		expect_null(label, p.get());
	}

	// expect non-null value
	static void expect_nonnull(const std::string& label, void* p)
	{
		// check for success
		bool success = (p != nullptr);

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		_failure("%s\t%p IS nullptr", label.c_str(), p);

		// throw exception
		throw_exception(test_failed_exception);
	}

	// expect non-null value (shared_ptr version)
	template<typename type> void expect_nonnull(const std::string& label, std::shared_ptr<type> p)
	{
		expect_nonnull(label, p.get());
	}
};

#define EXPECT_NULL(label, value)				test::expect_null(label, value);
#define EXPECT_NOTNULL(label, value)			test::expect_nonnull(label, value);