#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>

namespace test
{
	// expect integer
	static void expect_int(const std::string& label, size_t value1, size_t value2)
	{
		// check for success
		bool success = value1 == value2;

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		_failure("%s\t%zu is NOT %zu", label.c_str(), value1, value2);

		// throw exception
		throw_exception(test_failed_exception);
	}
};

#define EXPECT_INT(label, value1, value2)		test::expect_int(label, value1, value2);
#define EXPECT_ZERO(label, value)				test::expect_int(label, value, 0);