#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>

namespace test
{
	// expect boolean
	static void expect_exception(const std::string& label, std::function<void(void)> func)
	{
		// check for success
		bool success = false;

		try
		{
			if(func)
				func();
		}
		catch (...) {
			success = true;
		}

		// display success and exit
		if (success)
		{
			_success("%s\thas triggered exception", label.c_str());

			return;
		}

		// display failure
		_failure("%s\thas NOT triggered exception", label.c_str());

		// throw exception
		throw_exception(test_failed_exception);
	}
};

#define EXPECT_EXCEPTION(label, func)		test::expect_exception(label, func);