#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"
#include "../storage/buffer.h"
#include "../hash/sha2.h"
#include "../utils/base64.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>

namespace test
{
	// expect a string
	static void expect_data(const std::string& label, const storage::buffer& data1, const storage::buffer& data2)
	{
		// check for success
		bool success = data1.equals(data2);

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		auto hash1 = utils::base64::encode(sha256(data1));
		auto hash2 = utils::base64::encode(sha256(data2));

		_failure("%s\thash %s is NOT hash %s", label.c_str(), hash1.c_str(), hash2.c_str());

		// throw exception
		throw_exception(test_failed_exception);
	}
};

#define EXPECT_DATA(label, data1, data2)		test::expect_data(label, data1, data2);