#pragma once

#include "../utils/utils.h"
#include "../debug/evemon.h"

#include "exception.h"
#include "test.h"

#include <cstdlib>
#include <cstring>

namespace test
{
	// expect boolean
	static void expect_bool(const std::string& label, bool value1, bool value2)
	{
		// check for success
		bool success = value1 == value2;

		// display success and exit
		if (success)
		{
			_success("%s\tis ok", label.c_str());

			return;
		}

		// display failure
		_failure("%s\t\"%s\" is NOT \"%s\"", label.c_str(), value1 ? "true" : "false", value2 ? "true" : "false");

		// throw exception
		throw_exception(test_failed_exception);
	}
};

#define EXPECT_BOOL(label, value1, value2)		test::expect_bool(label, value1, value2);
#define EXPECT_TRUE(label, value)				test::expect_bool(label, value, true);
#define EXPECT_FALSE(label, value)				test::expect_bool(label, value, false);