#pragma once

#include "../utils/utils.h"
#include "../debug/exception.h"
#include "../utils/singleton.h"

#include "buffer.h"

#include <vector>
#include <string>

namespace storage
{
	// load buffer from file
	static storage::buffer load_buffer_from_file(const std::string& filename)
	{
		size_t size = 0;

		auto data = resources::load_from_file(filename, size);

		try
		{
			return storage::buffer(data, size);
		}
		catch (...)
		{
			free(data);

			throw;
		}
	}

	// save buffer to file
	static void save_buffer_to_file(const std::string& filename, const storage::buffer& obj)
	{
		resources::save_to_file(filename, obj.data(), obj.size());
	}

	static std::string buf2hex(const buffer& buf)
	{
		auto _atohex = [](unsigned char c)
		{
			const char lookup[] = { '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f' };

			char szTmp[2] = { lookup[c], '\0' };

			return std::string(szTmp);
		};

		std::string ret;

		auto p = buf.ptr<unsigned char>(0);

		for (size_t i = buf.size(); i > 0; i--)
		{
			ret += _atohex((p[i - 1] >> 4) & 0xf);
			ret += _atohex(p[i - 1] & 0xf);
		}

		return ret;
	}

	/*
	// load storage buffer from registry
	static storage_buffer load_buffer_from_registry(registry_root_key eRootKey, const char* pszRegistryKey, const char* pszValueName)
	{
		storage_buffer buffer;
		buffer.load_from_registry(eRootKey, pszRegistryKey, pszValueName);

		return buffer;
	}

	// load storage buffer from resource
	static storage_buffer load_buffer_from_resource(int iResourceID, HMODULE hModule = NULL)
	{
		// find resource inside current module
		auto hResource = FindResource(hModule, MAKEINTRESOURCE(iResourceID), RT_RCDATA);

		if (hResource == NULL)
			throwException(UnknownResourceException);

		// get resource size
		size_t nSize = SizeofResource(hModule, hResource);

		// load resource
		auto hGlobal = LoadResource(hModule, hResource);

		if (hGlobal == NULL)
			throwException(UnknownResourceException);

		// lock resource
		auto pData = LockResource(hGlobal);

		if (pData == NULL)
			throwException(UnknownResourceException);

		try
		{
			// create storage buffer
			storage_buffer ret((unsigned char*)pData, nSize);

			// unlock resource
			FreeResource(hGlobal);

			// return
			return ret;
		}
		catch (...)
		{
			// unlock resource and rethrow error
			FreeResource(hGlobal);

			throw;
		}
	}
	*/
};